/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.util;

import com.alexander.mutantmore.config.MutantMoreGroupedOptionsClientConfig;
import com.alexander.mutantmore.init.TagInit;
import com.alexander.mutantmore.interfaces.IHasBossMusic;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.registries.ForgeRegistries;

public class BossMusicUtils {
    public static boolean overridesBossMusic(ResourceLocation musicLocation) {
        for (SoundEvent soundEvent : ForgeRegistries.SOUND_EVENTS.tags().getTag(TagInit.SoundEvents.CAN_OVERRIDE_BOSS_MUSIC).stream().collect(Collectors.toList())) {
            if (musicLocation != soundEvent.m_11660_()) continue;
            return true;
        }
        return false;
    }

    public static boolean cantBeOverriddenByBossMusic(ResourceLocation musicLocation) {
        for (SoundEvent soundEvent : ForgeRegistries.SOUND_EVENTS.tags().getTag(TagInit.SoundEvents.CANT_BE_OVERRIDDEN_BY_BOSS_MUSIC).stream().collect(Collectors.toList())) {
            if (musicLocation != soundEvent.m_11660_()) continue;
            return true;
        }
        return false;
    }

    public static boolean isBossMusic(ResourceLocation musicLocation) {
        for (SoundEvent soundEvent : ForgeRegistries.SOUND_EVENTS.tags().getTag(TagInit.SoundEvents.BOSS_MUSIC).stream().collect(Collectors.toList())) {
            if (musicLocation != soundEvent.m_11660_()) continue;
            return true;
        }
        return false;
    }

    public static IHasBossMusic getSituationalBossMusicPlayer() {
        Minecraft minecraft = Minecraft.m_91087_();
        IHasBossMusic musicPlayer = null;
        if (minecraft.f_91074_ != null) {
            for (Entity entity : minecraft.f_91074_.f_19853_.m_45933_((Entity)minecraft.f_91074_, minecraft.f_91074_.m_20191_().m_82400_(100.0))) {
                IHasBossMusic hasBossMusic;
                if (!(entity instanceof IHasBossMusic) || !(hasBossMusic = (IHasBossMusic)entity).shouldPlayMusic()) continue;
                musicPlayer = hasBossMusic;
                break;
            }
        }
        return musicPlayer;
    }

    public static boolean canMobPlayBossMusic(Mob mob, boolean musicConfigOption, int targetedEntityID) {
        if (mob.f_19853_.f_46443_) {
            Entity targetedEntity;
            if (!musicConfigOption || ((Boolean)MutantMoreGroupedOptionsClientConfig.play_battle_music_off.get()).booleanValue()) {
                return false;
            }
            if (targetedEntityID != 0 && (targetedEntity = mob.f_19853_.m_6815_(targetedEntityID)) instanceof Player) {
                Player targetedPlayer = (Player)mob.f_19853_.m_6815_(targetedEntityID);
                if (Minecraft.m_91087_().f_91074_ == targetedPlayer) {
                    return true;
                }
                return mob.m_20270_((Entity)Minecraft.m_91087_().f_91074_) <= 30.0f;
            }
        }
        return false;
    }
}

